#pragma once

#include <vector>

using namespace std;

#define MAX_POINTS 10000

class CLine  
{
public:
	BOOL        m_bDraw;		// plot or not
	COLORREF	m_cColor;		//
	int         m_nStyle;		// solid, dash
	int         m_nThick;		// 1pixel, 2pixel
	
	CLine();
	CLine(int nStyle, COLORREF cColor, int nThick);
	CLine(const CLine &line);
	CLine &operator = (const CLine &line);
	virtual ~CLine();
	
	void AddPointXY(long x, long y);
	void AddPointVX(long x);
	void AddPointVY(long y);

	void AddHomePointX(long nPosX);
	void AddHomePointY(long nPosY);
	
	long GetPointX(int nIndex);
	long GetPointY(int nIndex);
	long GetPointVX(int nIndex);
	long GetPointVY(int nIndex);

	long GetHomeX(int nIndex);
	long GetHomeY(int nIndex);
	
	int GetHomePointXCount();
	int GetHomePointYCount();

	int GetPointXYCount();
	int GetPointVXCount();
	int GetPointVYCount();
	
	void RemoveAllXYPoints();
	void RemoveAllVTPoints();
	
	void RemoveUselessPointsXY();
	void RemoveUselessPointsVX();
	void RemoveUselessPointsVY();
	
private:
	vector<long>  m_nPosXValue;
	vector<long>  m_nPosYValue;
	
	vector<long>  m_nHomeXValue;
	vector<long>  m_nHomeYValue;

	vector<long>  m_nVecXValue;
	vector<long>  m_nVecYValue;
	
	CRITICAL_SECTION m_csXY;
	CRITICAL_SECTION m_csVX;
	CRITICAL_SECTION m_csVY;

	CRITICAL_SECTION m_csX;
	CRITICAL_SECTION m_csY;
};
